/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.reflect;

import com.google.gson.JsonIOException;
import com.google.gson.internal.reflect.ReflectionHelper$RecordHelper;
import com.google.gson.internal.reflect.ReflectionHelper$RecordNotSupportedHelper;
import com.google.gson.internal.reflect.ReflectionHelper$RecordSupportedHelper;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ReflectionHelper {
    private static final ReflectionHelper$RecordHelper RECORD_HELPER;

    private ReflectionHelper() {
    }

    public static void makeAccessible(AccessibleObject accessibleObject) {
        try {
            accessibleObject.setAccessible(true);
        }
        catch (Exception exception) {
            String string = ReflectionHelper.getAccessibleObjectDescription(accessibleObject, false);
            throw new JsonIOException("Failed making " + string + " accessible; either increase its visibility or write a custom TypeAdapter for its declaring type.", exception);
        }
    }

    public static String getAccessibleObjectDescription(AccessibleObject accessibleObject, boolean bl) {
        String string;
        if (accessibleObject instanceof Field) {
            string = "field '" + ReflectionHelper.fieldToString((Field)accessibleObject) + "'";
        } else if (accessibleObject instanceof Method) {
            Method method = (Method)accessibleObject;
            StringBuilder stringBuilder = new StringBuilder(method.getName());
            ReflectionHelper.appendExecutableParameters(method, stringBuilder);
            String string2 = stringBuilder.toString();
            string = "method '" + method.getDeclaringClass().getName() + "#" + string2 + "'";
        } else {
            string = accessibleObject instanceof Constructor ? "constructor '" + ReflectionHelper.constructorToString((Constructor)accessibleObject) + "'" : "<unknown AccessibleObject> " + accessibleObject.toString();
        }
        if (bl && Character.isLowerCase(string.charAt(0))) {
            string = Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }
        return string;
    }

    public static String fieldToString(Field field) {
        return field.getDeclaringClass().getName() + "#" + field.getName();
    }

    public static String constructorToString(Constructor<?> constructor) {
        StringBuilder stringBuilder = new StringBuilder(constructor.getDeclaringClass().getName());
        ReflectionHelper.appendExecutableParameters(constructor, stringBuilder);
        return stringBuilder.toString();
    }

    private static void appendExecutableParameters(AccessibleObject accessibleObject, StringBuilder stringBuilder) {
        stringBuilder.append('(');
        Class<?>[] classArray = accessibleObject instanceof Method ? ((Method)accessibleObject).getParameterTypes() : ((Constructor)accessibleObject).getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(classArray[i].getSimpleName());
        }
        stringBuilder.append(')');
    }

    public static String tryMakeAccessible(Constructor<?> constructor) {
        try {
            constructor.setAccessible(true);
            return null;
        }
        catch (Exception exception) {
            return "Failed making constructor '" + ReflectionHelper.constructorToString(constructor) + "' accessible; either increase its visibility or write a custom InstanceCreator or TypeAdapter for its declaring type: " + exception.getMessage();
        }
    }

    public static boolean isRecord(Class<?> clazz) {
        return RECORD_HELPER.isRecord(clazz);
    }

    public static String[] getRecordComponentNames(Class<?> clazz) {
        return RECORD_HELPER.getRecordComponentNames(clazz);
    }

    public static Method getAccessor(Class<?> clazz, Field field) {
        return RECORD_HELPER.getAccessor(clazz, field);
    }

    public static <T> Constructor<T> getCanonicalRecordConstructor(Class<T> clazz) {
        return RECORD_HELPER.getCanonicalRecordConstructor(clazz);
    }

    public static RuntimeException createExceptionForUnexpectedIllegalAccess(IllegalAccessException illegalAccessException) {
        throw new RuntimeException("Unexpected IllegalAccessException occurred (Gson 2.10.1). Certain ReflectionAccessFilter features require Java >= 9 to work correctly. If you are not using ReflectionAccessFilter, report this to the Gson maintainers.", illegalAccessException);
    }

    private static RuntimeException createExceptionForRecordReflectionException(ReflectiveOperationException reflectiveOperationException) {
        throw new RuntimeException("Unexpected ReflectiveOperationException occurred (Gson 2.10.1). To support Java records, reflection is utilized to read out information about records. All these invocations happens after it is established that records exist in the JVM. This exception is unexpected behavior.", reflectiveOperationException);
    }

    static /* synthetic */ RuntimeException access$300(ReflectiveOperationException reflectiveOperationException) {
        return ReflectionHelper.createExceptionForRecordReflectionException(reflectiveOperationException);
    }

    static {
        ReflectionHelper$RecordHelper reflectionHelper$RecordHelper;
        try {
            reflectionHelper$RecordHelper = new ReflectionHelper$RecordSupportedHelper(null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            reflectionHelper$RecordHelper = new ReflectionHelper$RecordNotSupportedHelper(null);
        }
        RECORD_HELPER = reflectionHelper$RecordHelper;
    }
}

