/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.internal;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Cleaner {
    private static final Cleaner INSTANCE = new Cleaner();
    private final ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
    private final Thread cleanerThread = new Thread(){

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Reference reference;
                        if (!((reference = Cleaner.this.referenceQueue.remove()) instanceof CleanerRef)) {
                            continue;
                        }
                        ((CleanerRef)reference).clean();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception exception) {
                    Logger.getLogger(Cleaner.class.getName()).log(Level.SEVERE, null, exception);
                    continue;
                }
                break;
            }
        }
    };
    private CleanerRef firstCleanable;

    public static Cleaner getCleaner() {
        return INSTANCE;
    }

    private Cleaner() {
        this.cleanerThread.setName("JNA Cleaner");
        this.cleanerThread.setDaemon(true);
        this.cleanerThread.start();
    }

    public synchronized Cleanable register(Object object, Runnable runnable) {
        return this.add(new CleanerRef(this, object, this.referenceQueue, runnable));
    }

    private synchronized CleanerRef add(CleanerRef cleanerRef) {
        if (this.firstCleanable == null) {
            this.firstCleanable = cleanerRef;
        } else {
            cleanerRef.setNext(this.firstCleanable);
            this.firstCleanable.setPrevious(cleanerRef);
            this.firstCleanable = cleanerRef;
        }
        return cleanerRef;
    }

    private synchronized boolean remove(CleanerRef cleanerRef) {
        boolean bl = false;
        if (cleanerRef == this.firstCleanable) {
            this.firstCleanable = cleanerRef.getNext();
            bl = true;
        }
        if (cleanerRef.getPrevious() != null) {
            cleanerRef.getPrevious().setNext(cleanerRef.getNext());
        }
        if (cleanerRef.getNext() != null) {
            cleanerRef.getNext().setPrevious(cleanerRef.getPrevious());
        }
        if (cleanerRef.getPrevious() != null || cleanerRef.getNext() != null) {
            bl = true;
        }
        cleanerRef.setNext(null);
        cleanerRef.setPrevious(null);
        return bl;
    }

    public static interface Cleanable {
        public void clean();
    }

    private static class CleanerRef
    extends PhantomReference<Object>
    implements Cleanable {
        private final Cleaner cleaner;
        private final Runnable cleanupTask;
        private CleanerRef previous;
        private CleanerRef next;

        public CleanerRef(Cleaner cleaner, Object object, ReferenceQueue<? super Object> referenceQueue, Runnable runnable) {
            super(object, referenceQueue);
            this.cleaner = cleaner;
            this.cleanupTask = runnable;
        }

        @Override
        public void clean() {
            if (this.cleaner.remove(this)) {
                this.cleanupTask.run();
            }
        }

        CleanerRef getPrevious() {
            return this.previous;
        }

        void setPrevious(CleanerRef cleanerRef) {
            this.previous = cleanerRef;
        }

        CleanerRef getNext() {
            return this.next;
        }

        void setNext(CleanerRef cleanerRef) {
            this.next = cleanerRef;
        }
    }
}

