/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.unix.aix;

import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.platform.unix.LibCAPI;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.jna.platform.unix.AixLibc;
import oshi.util.FileUtil;
import oshi.util.tuples.Pair;
import oshi.util.tuples.Triplet;

@ThreadSafe
public final class PsInfo {
    private static final Logger LOG = LoggerFactory.getLogger(PsInfo.class);
    private static final AixLibc LIBC = AixLibc.INSTANCE;
    private static final long PAGE_SIZE = 4096L;

    private PsInfo() {
    }

    public static AixLibc.AixPsInfo queryPsInfo(int n) {
        return new AixLibc.AixPsInfo(FileUtil.readAllBytesAsBuffer(String.format("/proc/%d/psinfo", n)));
    }

    public static AixLibc.AixLwpsInfo queryLwpsInfo(int n, int n2) {
        return new AixLibc.AixLwpsInfo(FileUtil.readAllBytesAsBuffer(String.format("/proc/%d/lwp/%d/lwpsinfo", n, n2)));
    }

    public static Triplet<Integer, Long, Long> queryArgsEnvAddrs(int n, AixLibc.AixPsInfo aixPsInfo) {
        if (aixPsInfo != null) {
            int n2 = aixPsInfo.pr_argc;
            if (n2 > 0) {
                long l = aixPsInfo.pr_argv;
                long l2 = aixPsInfo.pr_envp;
                return new Triplet<Integer, Long, Long>(n2, l, l2);
            }
            LOG.trace("Failed argc sanity check: argc={}", (Object)n2);
            return null;
        }
        LOG.trace("Failed to read psinfo file for pid: {} ", (Object)n);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<List<String>, Map<String, String>> queryArgsEnv(int n, AixLibc.AixPsInfo aixPsInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        Triplet<Integer, Long, Long> triplet = PsInfo.queryArgsEnvAddrs(n, aixPsInfo);
        if (triplet != null) {
            String string = "/proc/" + n + "/as";
            int n2 = LIBC.open(string, 0);
            if (n2 < 0) {
                LOG.trace("No permission to read file: {} ", (Object)string);
                return new Pair<List<String>, Map<String, String>>(arrayList, linkedHashMap);
            }
            try {
                long l;
                Object object;
                int n3 = triplet.getA();
                long l2 = triplet.getB();
                long l3 = triplet.getC();
                Path path = Paths.get("/proc/" + n + "/status", new String[0]);
                try {
                    object = Files.readAllBytes(path);
                    l = object[17] == 1 ? 8L : 4L;
                }
                catch (IOException iOException) {
                    Pair<List<String>, Map<String, String>> pair = new Pair<List<String>, Map<String, String>>(arrayList, linkedHashMap);
                    LIBC.close(n2);
                    return pair;
                }
                object = new Memory(8192L);
                try {
                    long l4;
                    long l5;
                    LibCAPI.size_t size_t2 = new LibCAPI.size_t(((Memory)object).size());
                    long l6 = PsInfo.conditionallyReadBufferFromStartOfPage(n2, (Memory)object, size_t2, 0L, l2);
                    long[] lArray = new long[n3];
                    long l7 = l5 = l6 == 0L ? 0L : PsInfo.getOffsetFromBuffer((Memory)object, l2 - l6, l);
                    if (l5 > 0L) {
                        for (int i = 0; i < n3; ++i) {
                            l4 = l5 + (long)i * l;
                            lArray[i] = (l6 = PsInfo.conditionallyReadBufferFromStartOfPage(n2, (Memory)object, size_t2, l6, l4)) == 0L ? 0L : PsInfo.getOffsetFromBuffer((Memory)object, l4 - l6, l);
                        }
                    }
                    l6 = PsInfo.conditionallyReadBufferFromStartOfPage(n2, (Memory)object, size_t2, l6, l3);
                    ArrayList<Long> arrayList2 = new ArrayList<Long>();
                    l4 = l6 == 0L ? 0L : PsInfo.getOffsetFromBuffer((Memory)object, l3 - l6, l);
                    int n4 = 500;
                    long l8 = l4;
                    while (l4 != 0L && --n4 > 0) {
                        long l9;
                        long l10 = l9 = (l6 = PsInfo.conditionallyReadBufferFromStartOfPage(n2, (Memory)object, size_t2, l6, l8)) == 0L ? 0L : PsInfo.getOffsetFromBuffer((Memory)object, l8 - l6, l);
                        if (l9 != 0L) {
                            arrayList2.add(l9);
                        }
                        l8 += l;
                    }
                    for (int i = 0; i < lArray.length && lArray[i] != 0L; ++i) {
                        String object2;
                        if ((l6 = PsInfo.conditionallyReadBufferFromStartOfPage(n2, (Memory)object, size_t2, l6, lArray[i])) == 0L || (object2 = ((Pointer)object).getString(lArray[i] - l6)).isEmpty()) continue;
                        arrayList.add(object2);
                    }
                    for (Long l11 : arrayList2) {
                        String string2;
                        int n5;
                        if ((l6 = PsInfo.conditionallyReadBufferFromStartOfPage(n2, (Memory)object, size_t2, l6, l11)) == 0L || (n5 = (string2 = ((Pointer)object).getString(l11 - l6)).indexOf(61)) <= 0) continue;
                        linkedHashMap.put(string2.substring(0, n5), string2.substring(n5 + 1));
                    }
                }
                finally {
                    ((Memory)object).close();
                }
            }
            finally {
                LIBC.close(n2);
            }
        }
        return new Pair<List<String>, Map<String, String>>(arrayList, linkedHashMap);
    }

    private static long conditionallyReadBufferFromStartOfPage(int n, Memory memory, LibCAPI.size_t size_t2, long l, long l2) {
        if (l2 < l || l2 - l > 4096L) {
            long l3 = Math.floorDiv(l2, 4096L) * 4096L;
            LibCAPI.ssize_t ssize_t2 = LIBC.pread(n, memory, size_t2, new NativeLong(l3));
            if (ssize_t2.longValue() < 4096L) {
                LOG.debug("Failed to read page from address space: {} bytes read", (Object)ssize_t2.longValue());
                return 0L;
            }
            return l3;
        }
        return l;
    }

    private static long getOffsetFromBuffer(Memory memory, long l, long l2) {
        return l2 == 8L ? memory.getLong(l) : (long)memory.getInt(l);
    }
}

