/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.aix;

import com.sun.jna.Native;
import com.sun.jna.platform.unix.aix.Perfstat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.unix.aix.Lssrad;
import oshi.driver.unix.aix.perfstat.PerfstatConfig;
import oshi.driver.unix.aix.perfstat.PerfstatCpu;
import oshi.hardware.CentralProcessor;
import oshi.hardware.common.AbstractCentralProcessor;
import oshi.util.ExecutingCommand;
import oshi.util.FileUtil;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.tuples.Pair;
import oshi.util.tuples.Triplet;

@ThreadSafe
final class AixCentralProcessor
extends AbstractCentralProcessor {
    private final Supplier<Perfstat.perfstat_cpu_total_t> cpuTotal = Memoizer.memoize(PerfstatCpu::queryCpuTotal, Memoizer.defaultExpiration());
    private final Supplier<Perfstat.perfstat_cpu_t[]> cpuProc = Memoizer.memoize(PerfstatCpu::queryCpu, Memoizer.defaultExpiration());
    private static final int SBITS = AixCentralProcessor.querySbits();
    private Perfstat.perfstat_partition_config_t config;
    private static final long USER_HZ = ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("getconf CLK_TCK"), 100L);

    AixCentralProcessor() {
    }

    @Override
    protected CentralProcessor.ProcessorIdentifier queryProcessorId() {
        String string8;
        String string2 = "unknown";
        String string3 = "";
        String string4 = "";
        boolean bl = false;
        String string5 = "Processor Type:";
        String string6 = "Processor Version:";
        String string7 = "CPU Type:";
        for (String string8 : ExecutingCommand.runNative("prtconf")) {
            if (string8.startsWith("Processor Type:")) {
                string3 = string8.split("Processor Type:")[1].trim();
                if (string3.startsWith("P")) {
                    string2 = "IBM";
                    continue;
                }
                if (!string3.startsWith("I")) continue;
                string2 = "Intel";
                continue;
            }
            if (string8.startsWith("Processor Version:")) {
                string4 = string8.split("Processor Version:")[1].trim();
                continue;
            }
            if (!string8.startsWith("CPU Type:")) continue;
            bl = string8.split("CPU Type:")[1].contains("64");
        }
        Object object = "";
        string8 = "";
        String string9 = Native.toString(this.config.machineID);
        if (string9.isEmpty()) {
            string9 = ExecutingCommand.getFirstAnswer("uname -m");
        }
        if (string9.length() > 10) {
            int n = string9.length() - 4;
            int n2 = string9.length() - 2;
            object = string9.substring(n, n2);
            string8 = string9.substring(n2);
        }
        return new CentralProcessor.ProcessorIdentifier(string2, string3, string4, (String)object, string8, string9, bl, (long)(this.config.processorMHz * 1000000.0));
    }

    @Override
    protected Triplet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.PhysicalProcessor>, List<CentralProcessor.ProcessorCache>> initProcessorCounts() {
        int n;
        this.config = PerfstatConfig.queryConfig();
        int n2 = (int)this.config.numProcessors.max;
        if (n2 < 1) {
            n2 = 1;
        }
        if ((n = (int)this.config.vcpus.max) < 1) {
            n = 1;
        }
        if (n2 > n) {
            n2 = n;
        }
        int n3 = n / n2;
        Map<Integer, Pair<Integer, Integer>> map = Lssrad.queryNodesPackages();
        ArrayList<CentralProcessor.LogicalProcessor> arrayList = new ArrayList<CentralProcessor.LogicalProcessor>();
        for (int i = 0; i < n; ++i) {
            Pair<Integer, Integer> pair = map.get(i);
            int n4 = i / n3;
            arrayList.add(new CentralProcessor.LogicalProcessor(i, n4, pair == null ? 0 : pair.getB(), pair == null ? 0 : pair.getA()));
        }
        return new Triplet(arrayList, null, this.getCachesForModel(n2));
    }

    private List<CentralProcessor.ProcessorCache> getCachesForModel(int n) {
        ArrayList<CentralProcessor.ProcessorCache> arrayList = new ArrayList<CentralProcessor.ProcessorCache>();
        int n2 = ParseUtil.getFirstIntValue(ExecutingCommand.getFirstAnswer("uname -n"));
        switch (n2) {
            case 7: {
                arrayList.add(new CentralProcessor.ProcessorCache(3, 8, 128, 0x4000000L, CentralProcessor.ProcessorCache.Type.UNIFIED));
                arrayList.add(new CentralProcessor.ProcessorCache(2, 8, 128, 262144L, CentralProcessor.ProcessorCache.Type.UNIFIED));
                arrayList.add(new CentralProcessor.ProcessorCache(1, 8, 128, 32768L, CentralProcessor.ProcessorCache.Type.DATA));
                arrayList.add(new CentralProcessor.ProcessorCache(1, 4, 128, 32768L, CentralProcessor.ProcessorCache.Type.INSTRUCTION));
                break;
            }
            case 8: {
                arrayList.add(new CentralProcessor.ProcessorCache(4, 8, 128, 0x10000000L, CentralProcessor.ProcessorCache.Type.UNIFIED));
                arrayList.add(new CentralProcessor.ProcessorCache(3, 8, 128, 0x2800000L, CentralProcessor.ProcessorCache.Type.UNIFIED));
                arrayList.add(new CentralProcessor.ProcessorCache(2, 8, 128, 524288L, CentralProcessor.ProcessorCache.Type.UNIFIED));
                arrayList.add(new CentralProcessor.ProcessorCache(1, 8, 128, 65536L, CentralProcessor.ProcessorCache.Type.DATA));
                arrayList.add(new CentralProcessor.ProcessorCache(1, 8, 128, 32768L, CentralProcessor.ProcessorCache.Type.INSTRUCTION));
                break;
            }
            case 9: {
                arrayList.add(new CentralProcessor.ProcessorCache(3, 20, 128, (long)(n * 10 << 20), CentralProcessor.ProcessorCache.Type.UNIFIED));
                arrayList.add(new CentralProcessor.ProcessorCache(2, 8, 128, 524288L, CentralProcessor.ProcessorCache.Type.UNIFIED));
                arrayList.add(new CentralProcessor.ProcessorCache(1, 8, 128, 32768L, CentralProcessor.ProcessorCache.Type.DATA));
                arrayList.add(new CentralProcessor.ProcessorCache(1, 8, 128, 32768L, CentralProcessor.ProcessorCache.Type.INSTRUCTION));
                break;
            }
        }
        return arrayList;
    }

    @Override
    public long[] querySystemCpuLoadTicks() {
        Perfstat.perfstat_cpu_total_t perfstat_cpu_total_t2 = this.cpuTotal.get();
        long[] lArray = new long[CentralProcessor.TickType.values().length];
        lArray[CentralProcessor.TickType.USER.ordinal()] = perfstat_cpu_total_t2.user * 1000L / USER_HZ;
        lArray[CentralProcessor.TickType.SYSTEM.ordinal()] = perfstat_cpu_total_t2.sys * 1000L / USER_HZ;
        lArray[CentralProcessor.TickType.IDLE.ordinal()] = perfstat_cpu_total_t2.idle * 1000L / USER_HZ;
        lArray[CentralProcessor.TickType.IOWAIT.ordinal()] = perfstat_cpu_total_t2.wait * 1000L / USER_HZ;
        lArray[CentralProcessor.TickType.IRQ.ordinal()] = perfstat_cpu_total_t2.devintrs * 1000L / USER_HZ;
        lArray[CentralProcessor.TickType.SOFTIRQ.ordinal()] = perfstat_cpu_total_t2.softintrs * 1000L / USER_HZ;
        lArray[CentralProcessor.TickType.STEAL.ordinal()] = (perfstat_cpu_total_t2.idle_stolen_purr + perfstat_cpu_total_t2.busy_stolen_purr) * 1000L / USER_HZ;
        return lArray;
    }

    @Override
    public long[] queryCurrentFreq() {
        long[] lArray = new long[this.getLogicalProcessorCount()];
        Arrays.fill(lArray, -1L);
        String string = "runs at";
        int n = 0;
        for (String string2 : ExecutingCommand.runNative("pmcycles -m")) {
            if (!string2.contains(string)) continue;
            lArray[n++] = ParseUtil.parseHertz(string2.split(string)[1].trim());
            if (n < lArray.length) continue;
            break;
        }
        return lArray;
    }

    @Override
    protected long queryMaxFreq() {
        Perfstat.perfstat_cpu_total_t perfstat_cpu_total_t2 = this.cpuTotal.get();
        return perfstat_cpu_total_t2.processorHZ;
    }

    @Override
    public double[] getSystemLoadAverage(int n) {
        if (n < 1 || n > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        double[] dArray = new double[n];
        long[] lArray = this.cpuTotal.get().loadavg;
        for (int i = 0; i < n; ++i) {
            dArray[i] = (double)lArray[i] / (double)(1L << SBITS);
        }
        return dArray;
    }

    @Override
    public long[][] queryProcessorCpuLoadTicks() {
        Perfstat.perfstat_cpu_t[] perfstat_cpu_tArray = this.cpuProc.get();
        long[][] lArray = new long[perfstat_cpu_tArray.length][CentralProcessor.TickType.values().length];
        for (int i = 0; i < perfstat_cpu_tArray.length; ++i) {
            lArray[i] = new long[CentralProcessor.TickType.values().length];
            lArray[i][CentralProcessor.TickType.USER.ordinal()] = perfstat_cpu_tArray[i].user * 1000L / USER_HZ;
            lArray[i][CentralProcessor.TickType.SYSTEM.ordinal()] = perfstat_cpu_tArray[i].sys * 1000L / USER_HZ;
            lArray[i][CentralProcessor.TickType.IDLE.ordinal()] = perfstat_cpu_tArray[i].idle * 1000L / USER_HZ;
            lArray[i][CentralProcessor.TickType.IOWAIT.ordinal()] = perfstat_cpu_tArray[i].wait * 1000L / USER_HZ;
            lArray[i][CentralProcessor.TickType.IRQ.ordinal()] = perfstat_cpu_tArray[i].devintrs * 1000L / USER_HZ;
            lArray[i][CentralProcessor.TickType.SOFTIRQ.ordinal()] = perfstat_cpu_tArray[i].softintrs * 1000L / USER_HZ;
            lArray[i][CentralProcessor.TickType.STEAL.ordinal()] = (perfstat_cpu_tArray[i].idle_stolen_purr + perfstat_cpu_tArray[i].busy_stolen_purr) * 1000L / USER_HZ;
        }
        return lArray;
    }

    @Override
    public long queryContextSwitches() {
        return this.cpuTotal.get().pswitch;
    }

    @Override
    public long queryInterrupts() {
        Perfstat.perfstat_cpu_total_t perfstat_cpu_total_t2 = this.cpuTotal.get();
        return perfstat_cpu_total_t2.devintrs + perfstat_cpu_total_t2.softintrs;
    }

    private static int querySbits() {
        for (String string : FileUtil.readFile("/usr/include/sys/proc.h")) {
            if (!string.contains("SBITS") || !string.contains("#define")) continue;
            return ParseUtil.parseLastInt(string, 16);
        }
        return 16;
    }
}

