/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.solaris;

import java.util.ArrayList;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.common.AbstractSensors;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

@ThreadSafe
final class SolarisSensors
extends AbstractSensors {
    SolarisSensors() {
    }

    @Override
    public double queryCpuTemperature() {
        double d = 0.0;
        for (String string : ExecutingCommand.runNative("/usr/sbin/prtpicl -v -c temperature-sensor")) {
            int n;
            if (!string.trim().startsWith("Temperature:") || !((double)(n = ParseUtil.parseLastInt(string, 0)) > d)) continue;
            d = n;
        }
        if (d > 1000.0) {
            d /= 1000.0;
        }
        return d;
    }

    @Override
    public int[] queryFanSpeeds() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (String string : ExecutingCommand.runNative("/usr/sbin/prtpicl -v -c fan")) {
            if (!string.trim().startsWith("Speed:")) continue;
            arrayList.add(ParseUtil.parseLastInt(string, 0));
        }
        Object object = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            object[i] = (Integer)arrayList.get(i);
        }
        return object;
    }

    @Override
    public double queryCpuVoltage() {
        double d = 0.0;
        for (String string : ExecutingCommand.runNative("/usr/sbin/prtpicl -v -c voltage-sensor")) {
            if (!string.trim().startsWith("Voltage:")) continue;
            d = ParseUtil.parseDoubleOrDefault(string.replace("Voltage:", "").trim(), 0.0);
            break;
        }
        return d;
    }
}

