/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.buffer;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import pro.gravit.repackage.io.netty.buffer.PoolArena$SizeClass;
import pro.gravit.repackage.io.netty.buffer.PoolArenaMetric;
import pro.gravit.repackage.io.netty.buffer.PoolArenasCache;
import pro.gravit.repackage.io.netty.buffer.PoolChunk;
import pro.gravit.repackage.io.netty.buffer.PoolChunkList;
import pro.gravit.repackage.io.netty.buffer.PoolChunkListMetric;
import pro.gravit.repackage.io.netty.buffer.PoolChunkMetric;
import pro.gravit.repackage.io.netty.buffer.PoolSubpage;
import pro.gravit.repackage.io.netty.buffer.PoolSubpageMetric;
import pro.gravit.repackage.io.netty.buffer.PooledByteBuf;
import pro.gravit.repackage.io.netty.buffer.PooledByteBufAllocator;
import pro.gravit.repackage.io.netty.buffer.SizeClasses;
import pro.gravit.repackage.io.netty.util.internal.LongCounter;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.StringUtil;

abstract class PoolArena<T>
extends SizeClasses
implements PoolArenaMetric {
    private static final boolean HAS_UNSAFE = PlatformDependent.hasUnsafe();
    final PooledByteBufAllocator parent;
    final int numSmallSubpagePools;
    final int directMemoryCacheAlignment;
    private final PoolSubpage<T>[] smallSubpagePools;
    private final PoolChunkList<T> q050;
    private final PoolChunkList<T> q025;
    private final PoolChunkList<T> q000;
    private final PoolChunkList<T> qInit;
    private final PoolChunkList<T> q075;
    private final PoolChunkList<T> q100;
    private final List<PoolChunkListMetric> chunkListMetrics;
    private long allocationsNormal;
    private final LongCounter allocationsSmall = PlatformDependent.newLongCounter();
    private final LongCounter allocationsHuge = PlatformDependent.newLongCounter();
    private final LongCounter activeBytesHuge = PlatformDependent.newLongCounter();
    private long deallocationsSmall;
    private long deallocationsNormal;
    private final LongCounter deallocationsHuge = PlatformDependent.newLongCounter();
    final AtomicInteger numThreadCaches = new AtomicInteger();
    private final ReentrantLock lock = new ReentrantLock();

    protected PoolArena(PooledByteBufAllocator pooledByteBufAllocator, int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.parent = pooledByteBufAllocator;
        this.directMemoryCacheAlignment = n4;
        this.numSmallSubpagePools = this.nSubpages;
        this.smallSubpagePools = this.newSubpagePoolArray(this.numSmallSubpagePools);
        for (int i = 0; i < this.smallSubpagePools.length; ++i) {
            this.smallSubpagePools[i] = this.newSubpagePoolHead();
        }
        this.q100 = new PoolChunkList(this, null, 100, Integer.MAX_VALUE, n3);
        this.q075 = new PoolChunkList<T>(this, this.q100, 75, 100, n3);
        this.q050 = new PoolChunkList<T>(this, this.q075, 50, 100, n3);
        this.q025 = new PoolChunkList<T>(this, this.q050, 25, 75, n3);
        this.q000 = new PoolChunkList<T>(this, this.q025, 1, 50, n3);
        this.qInit = new PoolChunkList<T>(this, this.q000, Integer.MIN_VALUE, 25, n3);
        this.q100.prevList(this.q075);
        this.q075.prevList(this.q050);
        this.q050.prevList(this.q025);
        this.q025.prevList(this.q000);
        this.q000.prevList(null);
        this.qInit.prevList(this.qInit);
        ArrayList<PoolChunkList<T>> arrayList = new ArrayList<PoolChunkList<T>>(6);
        arrayList.add(this.qInit);
        arrayList.add(this.q000);
        arrayList.add(this.q025);
        arrayList.add(this.q050);
        arrayList.add(this.q075);
        arrayList.add(this.q100);
        this.chunkListMetrics = Collections.unmodifiableList(arrayList);
    }

    private PoolSubpage<T> newSubpagePoolHead() {
        PoolSubpage poolSubpage = new PoolSubpage();
        poolSubpage.prev = poolSubpage;
        poolSubpage.next = poolSubpage;
        return poolSubpage;
    }

    private PoolSubpage<T>[] newSubpagePoolArray(int n) {
        return new PoolSubpage[n];
    }

    abstract boolean isDirect();

    PooledByteBuf<T> allocate(PoolArenasCache poolArenasCache, int n, int n2) {
        PooledByteBuf<T> pooledByteBuf = this.newByteBuf(n2);
        this.allocate(poolArenasCache, pooledByteBuf, n);
        return pooledByteBuf;
    }

    private void allocate(PoolArenasCache poolArenasCache, PooledByteBuf<T> pooledByteBuf, int n) {
        int n2 = this.size2SizeIdx(n);
        if (n2 <= this.smallMaxSizeIdx) {
            this.tcacheAllocateSmall(poolArenasCache, pooledByteBuf, n, n2);
        } else if (n2 < this.nSizes) {
            this.tcacheAllocateNormal(poolArenasCache, pooledByteBuf, n, n2);
        } else {
            int n3 = this.directMemoryCacheAlignment > 0 ? this.normalizeSize(n) : n;
            this.allocateHuge(pooledByteBuf, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tcacheAllocateSmall(PoolArenasCache poolArenasCache, PooledByteBuf<T> pooledByteBuf, int n, int n2) {
        boolean bl;
        if (poolArenasCache.allocateSmall(this, pooledByteBuf, n, n2)) {
            return;
        }
        PoolSubpage<T> poolSubpage = this.findSubpagePoolHead(n2);
        poolSubpage.lock();
        try {
            PoolSubpage poolSubpage2 = poolSubpage.next;
            boolean bl2 = bl = poolSubpage2 == poolSubpage;
            if (!bl) {
                assert (poolSubpage2.doNotDestroy && poolSubpage2.elemSize == this.sizeIdx2size(n2)) : "doNotDestroy=" + poolSubpage2.doNotDestroy + ", elemSize=" + poolSubpage2.elemSize + ", sizeIdx=" + n2;
                long l = poolSubpage2.allocate();
                assert (l >= 0L);
                poolSubpage2.chunk.initBufWithSubpage(pooledByteBuf, null, l, n, poolArenasCache);
            }
        }
        finally {
            poolSubpage.unlock();
        }
        if (bl) {
            this.lock();
            try {
                this.allocateNormal(pooledByteBuf, n, n2, poolArenasCache);
            }
            finally {
                this.unlock();
            }
        }
        this.incSmallAllocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tcacheAllocateNormal(PoolArenasCache poolArenasCache, PooledByteBuf<T> pooledByteBuf, int n, int n2) {
        if (poolArenasCache.allocateNormal(this, pooledByteBuf, n, n2)) {
            return;
        }
        this.lock();
        try {
            this.allocateNormal(pooledByteBuf, n, n2, poolArenasCache);
            ++this.allocationsNormal;
        }
        finally {
            this.unlock();
        }
    }

    private void allocateNormal(PooledByteBuf<T> pooledByteBuf, int n, int n2, PoolArenasCache poolArenasCache) {
        assert (this.lock.isHeldByCurrentThread());
        if (this.q050.allocate(pooledByteBuf, n, n2, poolArenasCache) || this.q025.allocate(pooledByteBuf, n, n2, poolArenasCache) || this.q000.allocate(pooledByteBuf, n, n2, poolArenasCache) || this.qInit.allocate(pooledByteBuf, n, n2, poolArenasCache) || this.q075.allocate(pooledByteBuf, n, n2, poolArenasCache)) {
            return;
        }
        PoolChunk<T> poolChunk = this.newChunk(this.pageSize, this.nPSizes, this.pageShifts, this.chunkSize);
        boolean bl = poolChunk.allocate(pooledByteBuf, n, n2, poolArenasCache);
        assert (bl);
        this.qInit.add(poolChunk);
    }

    private void incSmallAllocation() {
        this.allocationsSmall.increment();
    }

    private void allocateHuge(PooledByteBuf<T> pooledByteBuf, int n) {
        PoolChunk<T> poolChunk = this.newUnpooledChunk(n);
        this.activeBytesHuge.add(poolChunk.chunkSize());
        pooledByteBuf.initUnpooled(poolChunk, n);
        this.allocationsHuge.increment();
    }

    void free(PoolChunk<T> poolChunk, ByteBuffer byteBuffer, long l, int n, PoolArenasCache poolArenasCache) {
        if (poolChunk.unpooled) {
            int n2 = poolChunk.chunkSize();
            this.destroyChunk(poolChunk);
            this.activeBytesHuge.add(-n2);
            this.deallocationsHuge.increment();
        } else {
            PoolArena$SizeClass poolArena$SizeClass = PoolArena.sizeClass(l);
            if (poolArenasCache != null && poolArenasCache.add(this, poolChunk, byteBuffer, l, n, poolArena$SizeClass)) {
                return;
            }
            this.freeChunk(poolChunk, l, n, poolArena$SizeClass, byteBuffer, false);
        }
    }

    private static PoolArena$SizeClass sizeClass(long l) {
        return PoolChunk.isSubpage(l) ? PoolArena$SizeClass.Small : PoolArena$SizeClass.Normal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeChunk(PoolChunk<T> poolChunk, long l, int n, PoolArena$SizeClass poolArena$SizeClass, ByteBuffer byteBuffer, boolean bl) {
        boolean bl2;
        this.lock();
        try {
            if (!bl) {
                switch (poolArena$SizeClass) {
                    case Normal: {
                        ++this.deallocationsNormal;
                        break;
                    }
                    case Small: {
                        ++this.deallocationsSmall;
                        break;
                    }
                    default: {
                        throw new Error();
                    }
                }
            }
            bl2 = !poolChunk.parent.free(poolChunk, l, n, byteBuffer);
        }
        finally {
            this.unlock();
        }
        if (bl2) {
            this.destroyChunk(poolChunk);
        }
    }

    PoolSubpage<T> findSubpagePoolHead(int n) {
        return this.smallSubpagePools[n];
    }

    void reallocate(PooledByteBuf<T> pooledByteBuf, int n, boolean bl) {
        int n2;
        assert (n >= 0 && n <= pooledByteBuf.maxCapacity());
        int n3 = pooledByteBuf.length;
        if (n3 == n) {
            return;
        }
        PoolChunk poolChunk = pooledByteBuf.chunk;
        ByteBuffer byteBuffer = pooledByteBuf.tmpNioBuf;
        long l = pooledByteBuf.handle;
        Object t = pooledByteBuf.memory;
        int n4 = pooledByteBuf.offset;
        int n5 = pooledByteBuf.maxLength;
        this.allocate(this.parent.threadCache(), pooledByteBuf, n);
        if (n > n3) {
            n2 = n3;
        } else {
            pooledByteBuf.trimIndicesToCapacity(n);
            n2 = n;
        }
        this.memoryCopy(t, n4, pooledByteBuf, n2);
        if (bl) {
            this.free(poolChunk, byteBuffer, l, n5, pooledByteBuf.cache);
        }
    }

    @Override
    public int numThreadCaches() {
        return this.numThreadCaches.get();
    }

    @Override
    public int numTinySubpages() {
        return 0;
    }

    @Override
    public int numSmallSubpages() {
        return this.smallSubpagePools.length;
    }

    @Override
    public int numChunkLists() {
        return this.chunkListMetrics.size();
    }

    @Override
    public List<PoolSubpageMetric> tinySubpages() {
        return Collections.emptyList();
    }

    @Override
    public List<PoolSubpageMetric> smallSubpages() {
        return PoolArena.subPageMetricList(this.smallSubpagePools);
    }

    @Override
    public List<PoolChunkListMetric> chunkLists() {
        return this.chunkListMetrics;
    }

    private static List<PoolSubpageMetric> subPageMetricList(PoolSubpage<?>[] poolSubpageArray) {
        ArrayList<PoolSubpageMetric> arrayList = new ArrayList<PoolSubpageMetric>();
        for (PoolSubpage<?> poolSubpage : poolSubpageArray) {
            if (poolSubpage.next == poolSubpage) continue;
            PoolSubpage poolSubpage2 = poolSubpage.next;
            do {
                arrayList.add(poolSubpage2);
            } while ((poolSubpage2 = poolSubpage2.next) != poolSubpage);
        }
        return arrayList;
    }

    @Override
    public long numAllocations() {
        long l;
        this.lock();
        try {
            l = this.allocationsNormal;
        }
        finally {
            this.unlock();
        }
        return this.allocationsSmall.value() + l + this.allocationsHuge.value();
    }

    @Override
    public long numTinyAllocations() {
        return 0L;
    }

    @Override
    public long numSmallAllocations() {
        return this.allocationsSmall.value();
    }

    @Override
    public long numNormalAllocations() {
        this.lock();
        try {
            long l = this.allocationsNormal;
            return l;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public long numDeallocations() {
        long l;
        this.lock();
        try {
            l = this.deallocationsSmall + this.deallocationsNormal;
        }
        finally {
            this.unlock();
        }
        return l + this.deallocationsHuge.value();
    }

    @Override
    public long numTinyDeallocations() {
        return 0L;
    }

    @Override
    public long numSmallDeallocations() {
        this.lock();
        try {
            long l = this.deallocationsSmall;
            return l;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public long numNormalDeallocations() {
        this.lock();
        try {
            long l = this.deallocationsNormal;
            return l;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public long numHugeAllocations() {
        return this.allocationsHuge.value();
    }

    @Override
    public long numHugeDeallocations() {
        return this.deallocationsHuge.value();
    }

    @Override
    public long numActiveAllocations() {
        long l = this.allocationsSmall.value() + this.allocationsHuge.value() - this.deallocationsHuge.value();
        this.lock();
        try {
        }
        finally {
            this.unlock();
        }
        return Math.max(l += this.allocationsNormal - (this.deallocationsSmall + this.deallocationsNormal), 0L);
    }

    @Override
    public long numActiveTinyAllocations() {
        return 0L;
    }

    @Override
    public long numActiveSmallAllocations() {
        return Math.max(this.numSmallAllocations() - this.numSmallDeallocations(), 0L);
    }

    @Override
    public long numActiveNormalAllocations() {
        long l;
        this.lock();
        try {
            l = this.allocationsNormal - this.deallocationsNormal;
        }
        finally {
            this.unlock();
        }
        return Math.max(l, 0L);
    }

    @Override
    public long numActiveHugeAllocations() {
        return Math.max(this.numHugeAllocations() - this.numHugeDeallocations(), 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long numActiveBytes() {
        long l = this.activeBytesHuge.value();
        this.lock();
        try {
            for (int i = 0; i < this.chunkListMetrics.size(); ++i) {
                for (PoolChunkMetric poolChunkMetric : this.chunkListMetrics.get(i)) {
                    l += (long)poolChunkMetric.chunkSize();
                }
            }
        }
        finally {
            this.unlock();
        }
        return Math.max(0L, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long numPinnedBytes() {
        long l = this.activeBytesHuge.value();
        this.lock();
        try {
            for (int i = 0; i < this.chunkListMetrics.size(); ++i) {
                for (PoolChunkMetric poolChunkMetric : this.chunkListMetrics.get(i)) {
                    l += (long)((PoolChunk)poolChunkMetric).pinnedBytes();
                }
            }
        }
        finally {
            this.unlock();
        }
        return Math.max(0L, l);
    }

    protected abstract PoolChunk<T> newChunk(int var1, int var2, int var3, int var4);

    protected abstract PoolChunk<T> newUnpooledChunk(int var1);

    protected abstract PooledByteBuf<T> newByteBuf(int var1);

    protected abstract void memoryCopy(T var1, int var2, PooledByteBuf<T> var3, int var4);

    protected abstract void destroyChunk(PoolChunk<T> var1);

    public String toString() {
        this.lock();
        try {
            StringBuilder stringBuilder = new StringBuilder().append("Chunk(s) at 0~25%:").append(StringUtil.NEWLINE).append(this.qInit).append(StringUtil.NEWLINE).append("Chunk(s) at 0~50%:").append(StringUtil.NEWLINE).append(this.q000).append(StringUtil.NEWLINE).append("Chunk(s) at 25~75%:").append(StringUtil.NEWLINE).append(this.q025).append(StringUtil.NEWLINE).append("Chunk(s) at 50~100%:").append(StringUtil.NEWLINE).append(this.q050).append(StringUtil.NEWLINE).append("Chunk(s) at 75~100%:").append(StringUtil.NEWLINE).append(this.q075).append(StringUtil.NEWLINE).append("Chunk(s) at 100%:").append(StringUtil.NEWLINE).append(this.q100).append(StringUtil.NEWLINE).append("small subpages:");
            PoolArena.appendPoolSubPages(stringBuilder, this.smallSubpagePools);
            stringBuilder.append(StringUtil.NEWLINE);
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            this.unlock();
        }
    }

    private static void appendPoolSubPages(StringBuilder stringBuilder, PoolSubpage<?>[] poolSubpageArray) {
        for (int i = 0; i < poolSubpageArray.length; ++i) {
            PoolSubpage<?> poolSubpage = poolSubpageArray[i];
            if (poolSubpage.next == poolSubpage || poolSubpage.next == null) continue;
            stringBuilder.append(StringUtil.NEWLINE).append(i).append(": ");
            PoolSubpage poolSubpage2 = poolSubpage.next;
            while (poolSubpage2 != null) {
                stringBuilder.append(poolSubpage2);
                poolSubpage2 = poolSubpage2.next;
                if (poolSubpage2 != poolSubpage) continue;
            }
        }
    }

    protected final void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            PoolArena.destroyPoolSubPages(this.smallSubpagePools);
            this.destroyPoolChunkLists(this.qInit, this.q000, this.q025, this.q050, this.q075, this.q100);
            throw throwable;
        }
        PoolArena.destroyPoolSubPages(this.smallSubpagePools);
        this.destroyPoolChunkLists(this.qInit, this.q000, this.q025, this.q050, this.q075, this.q100);
    }

    private static void destroyPoolSubPages(PoolSubpage<?>[] poolSubpageArray) {
        for (PoolSubpage<?> poolSubpage : poolSubpageArray) {
            poolSubpage.destroy();
        }
    }

    private void destroyPoolChunkLists(PoolChunkList<T> ... poolChunkListArray) {
        for (PoolChunkList<T> poolChunkList : poolChunkListArray) {
            poolChunkList.destroy(this);
        }
    }

    void lock() {
        this.lock.lock();
    }

    void unlock() {
        this.lock.unlock();
    }

    static /* synthetic */ boolean access$000() {
        return HAS_UNSAFE;
    }
}

