/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.buffer;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import pro.gravit.repackage.io.netty.buffer.PoolArena;
import pro.gravit.repackage.io.netty.buffer.PoolArena$SizeClass;
import pro.gravit.repackage.io.netty.buffer.PoolArenasCache;
import pro.gravit.repackage.io.netty.buffer.PoolChunk;
import pro.gravit.repackage.io.netty.buffer.PoolThreadCache$MemoryRegionCache;
import pro.gravit.repackage.io.netty.buffer.PoolThreadCache$NormalMemoryRegionCache;
import pro.gravit.repackage.io.netty.buffer.PoolThreadCache$SubPageMemoryRegionCache;
import pro.gravit.repackage.io.netty.buffer.PooledByteBuf;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

final class PoolThreadCache
extends PoolArenasCache {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PoolThreadCache.class);
    private final PoolThreadCache$MemoryRegionCache<byte[]>[] smallSubPageHeapCaches;
    private final PoolThreadCache$MemoryRegionCache<ByteBuffer>[] smallSubPageDirectCaches;
    private final PoolThreadCache$MemoryRegionCache<byte[]>[] normalHeapCaches;
    private final PoolThreadCache$MemoryRegionCache<ByteBuffer>[] normalDirectCaches;
    private final int freeSweepAllocationThreshold;
    private final AtomicBoolean freed = new AtomicBoolean();
    private int allocations;

    PoolThreadCache(PoolArena<byte[]> poolArena, PoolArena<ByteBuffer> poolArena2, int n, int n2, int n3, int n4) {
        super(poolArena, poolArena2);
        ObjectUtil.checkPositiveOrZero(n3, "maxCachedBufferCapacity");
        this.freeSweepAllocationThreshold = n4;
        if (poolArena2 != null) {
            this.smallSubPageDirectCaches = PoolThreadCache.createSubPageCaches(n, poolArena2.numSmallSubpagePools);
            this.normalDirectCaches = PoolThreadCache.createNormalCaches(n2, n3, poolArena2);
            poolArena2.numThreadCaches.getAndIncrement();
        } else {
            this.smallSubPageDirectCaches = null;
            this.normalDirectCaches = null;
        }
        if (poolArena != null) {
            this.smallSubPageHeapCaches = PoolThreadCache.createSubPageCaches(n, poolArena.numSmallSubpagePools);
            this.normalHeapCaches = PoolThreadCache.createNormalCaches(n2, n3, poolArena);
            poolArena.numThreadCaches.getAndIncrement();
        } else {
            this.smallSubPageHeapCaches = null;
            this.normalHeapCaches = null;
        }
        if ((this.smallSubPageDirectCaches != null || this.normalDirectCaches != null || this.smallSubPageHeapCaches != null || this.normalHeapCaches != null) && n4 < 1) {
            throw new IllegalArgumentException("freeSweepAllocationThreshold: " + n4 + " (expected: > 0)");
        }
    }

    private static <T> PoolThreadCache$MemoryRegionCache<T>[] createSubPageCaches(int n, int n2) {
        if (n > 0 && n2 > 0) {
            PoolThreadCache$MemoryRegionCache[] poolThreadCache$MemoryRegionCacheArray = new PoolThreadCache$MemoryRegionCache[n2];
            for (int i = 0; i < poolThreadCache$MemoryRegionCacheArray.length; ++i) {
                poolThreadCache$MemoryRegionCacheArray[i] = new PoolThreadCache$SubPageMemoryRegionCache(n);
            }
            return poolThreadCache$MemoryRegionCacheArray;
        }
        return null;
    }

    private static <T> PoolThreadCache$MemoryRegionCache<T>[] createNormalCaches(int n, int n2, PoolArena<T> poolArena) {
        if (n > 0 && n2 > 0) {
            int n3 = Math.min(poolArena.chunkSize, n2);
            ArrayList arrayList = new ArrayList();
            for (int i = poolArena.numSmallSubpagePools; i < poolArena.nSizes && poolArena.sizeIdx2size(i) <= n3; ++i) {
                arrayList.add(new PoolThreadCache$NormalMemoryRegionCache(n));
            }
            return arrayList.toArray(new PoolThreadCache$MemoryRegionCache[0]);
        }
        return null;
    }

    @Override
    boolean allocateSmall(PoolArena<?> poolArena, PooledByteBuf<?> pooledByteBuf, int n, int n2) {
        return this.allocate(this.cacheForSmall(poolArena, n2), pooledByteBuf, n);
    }

    @Override
    boolean allocateNormal(PoolArena<?> poolArena, PooledByteBuf<?> pooledByteBuf, int n, int n2) {
        return this.allocate(this.cacheForNormal(poolArena, n2), pooledByteBuf, n);
    }

    private boolean allocate(PoolThreadCache$MemoryRegionCache<?> poolThreadCache$MemoryRegionCache, PooledByteBuf pooledByteBuf, int n) {
        if (poolThreadCache$MemoryRegionCache == null) {
            return false;
        }
        boolean bl = poolThreadCache$MemoryRegionCache.allocate(pooledByteBuf, n, this);
        if (++this.allocations >= this.freeSweepAllocationThreshold) {
            this.allocations = 0;
            this.trim();
        }
        return bl;
    }

    @Override
    boolean add(PoolArena<?> poolArena, PoolChunk poolChunk, ByteBuffer byteBuffer, long l, int n, PoolArena$SizeClass poolArena$SizeClass) {
        int n2 = poolArena.size2SizeIdx(n);
        PoolThreadCache$MemoryRegionCache<?> poolThreadCache$MemoryRegionCache = this.cache(poolArena, n2, poolArena$SizeClass);
        if (poolThreadCache$MemoryRegionCache == null) {
            return false;
        }
        if (this.freed.get()) {
            return false;
        }
        return poolThreadCache$MemoryRegionCache.add(poolChunk, byteBuffer, l, n);
    }

    private PoolThreadCache$MemoryRegionCache<?> cache(PoolArena<?> poolArena, int n, PoolArena$SizeClass poolArena$SizeClass) {
        switch (poolArena$SizeClass) {
            case Normal: {
                return this.cacheForNormal(poolArena, n);
            }
            case Small: {
                return this.cacheForSmall(poolArena, n);
            }
        }
        throw new Error();
    }

    protected void finalize() {
        try {
            super.finalize();
        }
        finally {
            this.free(true);
        }
    }

    @Override
    void free(boolean bl) {
        if (this.freed.compareAndSet(false, true)) {
            int n = PoolThreadCache.free(this.smallSubPageDirectCaches, bl) + PoolThreadCache.free(this.normalDirectCaches, bl) + PoolThreadCache.free(this.smallSubPageHeapCaches, bl) + PoolThreadCache.free(this.normalHeapCaches, bl);
            if (n > 0 && logger.isDebugEnabled()) {
                logger.debug("Freed {} thread-local buffer(s) from thread: {}", (Object)n, (Object)Thread.currentThread().getName());
            }
            if (this.directArena != null) {
                this.directArena.numThreadCaches.getAndDecrement();
            }
            if (this.heapArena != null) {
                this.heapArena.numThreadCaches.getAndDecrement();
            }
        } else {
            PoolThreadCache.checkCacheMayLeak(this.smallSubPageDirectCaches, "SmallSubPageDirectCaches");
            PoolThreadCache.checkCacheMayLeak(this.normalDirectCaches, "NormalDirectCaches");
            PoolThreadCache.checkCacheMayLeak(this.smallSubPageHeapCaches, "SmallSubPageHeapCaches");
            PoolThreadCache.checkCacheMayLeak(this.normalHeapCaches, "NormalHeapCaches");
        }
    }

    private static void checkCacheMayLeak(PoolThreadCache$MemoryRegionCache<?>[] poolThreadCache$MemoryRegionCacheArray, String string) {
        for (PoolThreadCache$MemoryRegionCache<?> poolThreadCache$MemoryRegionCache : poolThreadCache$MemoryRegionCacheArray) {
            if (PoolThreadCache$MemoryRegionCache.access$000(poolThreadCache$MemoryRegionCache).isEmpty()) continue;
            logger.debug("{} memory may leak.", (Object)string);
            return;
        }
    }

    private static int free(PoolThreadCache$MemoryRegionCache<?>[] poolThreadCache$MemoryRegionCacheArray, boolean bl) {
        if (poolThreadCache$MemoryRegionCacheArray == null) {
            return 0;
        }
        int n = 0;
        for (PoolThreadCache$MemoryRegionCache<?> poolThreadCache$MemoryRegionCache : poolThreadCache$MemoryRegionCacheArray) {
            n += PoolThreadCache.free(poolThreadCache$MemoryRegionCache, bl);
        }
        return n;
    }

    private static int free(PoolThreadCache$MemoryRegionCache<?> poolThreadCache$MemoryRegionCache, boolean bl) {
        if (poolThreadCache$MemoryRegionCache == null) {
            return 0;
        }
        return poolThreadCache$MemoryRegionCache.free(bl);
    }

    @Override
    void trim() {
        PoolThreadCache.trim(this.smallSubPageDirectCaches);
        PoolThreadCache.trim(this.normalDirectCaches);
        PoolThreadCache.trim(this.smallSubPageHeapCaches);
        PoolThreadCache.trim(this.normalHeapCaches);
    }

    private static void trim(PoolThreadCache$MemoryRegionCache<?>[] poolThreadCache$MemoryRegionCacheArray) {
        if (poolThreadCache$MemoryRegionCacheArray == null) {
            return;
        }
        for (PoolThreadCache$MemoryRegionCache<?> poolThreadCache$MemoryRegionCache : poolThreadCache$MemoryRegionCacheArray) {
            PoolThreadCache.trim(poolThreadCache$MemoryRegionCache);
        }
    }

    private static void trim(PoolThreadCache$MemoryRegionCache<?> poolThreadCache$MemoryRegionCache) {
        if (poolThreadCache$MemoryRegionCache == null) {
            return;
        }
        poolThreadCache$MemoryRegionCache.trim();
    }

    private PoolThreadCache$MemoryRegionCache<?> cacheForSmall(PoolArena<?> poolArena, int n) {
        if (poolArena.isDirect()) {
            return PoolThreadCache.cache(this.smallSubPageDirectCaches, n);
        }
        return PoolThreadCache.cache(this.smallSubPageHeapCaches, n);
    }

    private PoolThreadCache$MemoryRegionCache<?> cacheForNormal(PoolArena<?> poolArena, int n) {
        int n2 = n - poolArena.numSmallSubpagePools;
        if (poolArena.isDirect()) {
            return PoolThreadCache.cache(this.normalDirectCaches, n2);
        }
        return PoolThreadCache.cache(this.normalHeapCaches, n2);
    }

    private static <T> PoolThreadCache$MemoryRegionCache<T> cache(PoolThreadCache$MemoryRegionCache<T>[] poolThreadCache$MemoryRegionCacheArray, int n) {
        if (poolThreadCache$MemoryRegionCacheArray == null || n > poolThreadCache$MemoryRegionCacheArray.length - 1) {
            return null;
        }
        return poolThreadCache$MemoryRegionCacheArray[n];
    }
}

