/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec;

import java.util.AbstractList;
import java.util.RandomAccess;
import pro.gravit.repackage.io.netty.handler.codec.CodecOutputList$1;
import pro.gravit.repackage.io.netty.handler.codec.CodecOutputList$2;
import pro.gravit.repackage.io.netty.handler.codec.CodecOutputList$CodecOutputListRecycler;
import pro.gravit.repackage.io.netty.handler.codec.CodecOutputList$CodecOutputLists;
import pro.gravit.repackage.io.netty.util.concurrent.FastThreadLocal;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

final class CodecOutputList
extends AbstractList<Object>
implements RandomAccess {
    private static final CodecOutputList$CodecOutputListRecycler NOOP_RECYCLER = new CodecOutputList$1();
    private static final FastThreadLocal<CodecOutputList$CodecOutputLists> CODEC_OUTPUT_LISTS_POOL = new CodecOutputList$2();
    private final CodecOutputList$CodecOutputListRecycler recycler;
    private int size;
    private Object[] array;
    private boolean insertSinceRecycled;

    static CodecOutputList newInstance() {
        return CODEC_OUTPUT_LISTS_POOL.get().getOrCreate();
    }

    private CodecOutputList(CodecOutputList$CodecOutputListRecycler codecOutputList$CodecOutputListRecycler, int n) {
        this.recycler = codecOutputList$CodecOutputListRecycler;
        this.array = new Object[n];
    }

    @Override
    public Object get(int n) {
        this.checkIndex(n);
        return this.array[n];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(Object object) {
        ObjectUtil.checkNotNull(object, "element");
        try {
            this.insert(this.size, object);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.expandArray();
            this.insert(this.size, object);
        }
        ++this.size;
        return true;
    }

    @Override
    public Object set(int n, Object object) {
        ObjectUtil.checkNotNull(object, "element");
        this.checkIndex(n);
        Object object2 = this.array[n];
        this.insert(n, object);
        return object2;
    }

    @Override
    public void add(int n, Object object) {
        ObjectUtil.checkNotNull(object, "element");
        this.checkIndex(n);
        if (this.size == this.array.length) {
            this.expandArray();
        }
        if (n != this.size) {
            System.arraycopy(this.array, n, this.array, n + 1, this.size - n);
        }
        this.insert(n, object);
        ++this.size;
    }

    @Override
    public Object remove(int n) {
        this.checkIndex(n);
        Object object = this.array[n];
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.array, n + 1, this.array, n, n2);
        }
        this.array[--this.size] = null;
        return object;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    boolean insertSinceRecycled() {
        return this.insertSinceRecycled;
    }

    void recycle() {
        for (int i = 0; i < this.size; ++i) {
            this.array[i] = null;
        }
        this.size = 0;
        this.insertSinceRecycled = false;
        this.recycler.recycle(this);
    }

    Object getUnsafe(int n) {
        return this.array[n];
    }

    private void checkIndex(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("expected: index < (" + this.size + "),but actual is (" + this.size + ")");
        }
    }

    private void insert(int n, Object object) {
        this.array[n] = object;
        this.insertSinceRecycled = true;
    }

    private void expandArray() {
        int n = this.array.length << 1;
        if (n < 0) {
            throw new OutOfMemoryError();
        }
        Object[] objectArray = new Object[n];
        System.arraycopy(this.array, 0, objectArray, 0, this.array.length);
        this.array = objectArray;
    }

    /* synthetic */ CodecOutputList(CodecOutputList$CodecOutputListRecycler codecOutputList$CodecOutputListRecycler, int n, CodecOutputList$1 var3_3) {
        this(codecOutputList$CodecOutputListRecycler, n);
    }

    static /* synthetic */ CodecOutputList$CodecOutputListRecycler access$100() {
        return NOOP_RECYCLER;
    }
}

