/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.compression;

import pro.gravit.repackage.io.netty.handler.codec.compression.CompressionOptions;
import pro.gravit.repackage.io.netty.handler.codec.compression.Zstd;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public class ZstdOptions
implements CompressionOptions {
    private final int blockSize;
    private final int compressionLevel;
    private final int maxEncodeSize;
    static final ZstdOptions DEFAULT = new ZstdOptions(3, 65536, 0x2000000);

    ZstdOptions(int n, int n2, int n3) {
        if (!Zstd.isAvailable()) {
            throw new IllegalStateException("zstd-jni is not available", Zstd.cause());
        }
        this.compressionLevel = ObjectUtil.checkInRange(n, 0, 22, "compressionLevel");
        this.blockSize = ObjectUtil.checkPositive(n2, "blockSize");
        this.maxEncodeSize = ObjectUtil.checkPositive(n3, "maxEncodeSize");
    }

    public int compressionLevel() {
        return this.compressionLevel;
    }

    public int blockSize() {
        return this.blockSize;
    }

    public int maxEncodeSize() {
        return this.maxEncodeSize;
    }
}

