/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.multipart;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.AbstractMemoryHttpData;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpData;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.InterfaceHttpData;
import pro.gravit.repackage.io.netty.util.AbstractReferenceCounted;

abstract class AbstractMixedHttpData<D extends HttpData>
extends AbstractReferenceCounted
implements HttpData {
    final String baseDir;
    final boolean deleteOnExit;
    D wrapped;
    private final long limitSize;

    AbstractMixedHttpData(long l, String string, boolean bl, D d) {
        this.limitSize = l;
        this.wrapped = d;
        this.baseDir = string;
        this.deleteOnExit = bl;
    }

    abstract D makeDiskData();

    @Override
    public long getMaxSize() {
        return this.wrapped.getMaxSize();
    }

    @Override
    public void setMaxSize(long l) {
        this.wrapped.setMaxSize(l);
    }

    @Override
    public ByteBuf content() {
        return this.wrapped.content();
    }

    @Override
    public void checkSize(long l) {
        this.wrapped.checkSize(l);
    }

    @Override
    public long definedLength() {
        return this.wrapped.definedLength();
    }

    @Override
    public Charset getCharset() {
        return this.wrapped.getCharset();
    }

    @Override
    public String getName() {
        return this.wrapped.getName();
    }

    @Override
    public void addContent(ByteBuf byteBuf, boolean bl) {
        if (this.wrapped instanceof AbstractMemoryHttpData) {
            try {
                this.checkSize(this.wrapped.length() + (long)byteBuf.readableBytes());
                if (this.wrapped.length() + (long)byteBuf.readableBytes() > this.limitSize) {
                    D d = this.makeDiskData();
                    ByteBuf byteBuf2 = ((AbstractMemoryHttpData)this.wrapped).getByteBuf();
                    if (byteBuf2 != null && byteBuf2.isReadable()) {
                        d.addContent(byteBuf2.retain(), false);
                    }
                    this.wrapped.release();
                    this.wrapped = d;
                }
            }
            catch (IOException iOException) {
                byteBuf.release();
                throw iOException;
            }
        }
        this.wrapped.addContent(byteBuf, bl);
    }

    @Override
    protected void deallocate() {
        this.delete();
    }

    @Override
    public void delete() {
        this.wrapped.delete();
    }

    @Override
    public byte[] get() {
        return this.wrapped.get();
    }

    @Override
    public ByteBuf getByteBuf() {
        return this.wrapped.getByteBuf();
    }

    @Override
    public String getString() {
        return this.wrapped.getString();
    }

    @Override
    public String getString(Charset charset) {
        return this.wrapped.getString(charset);
    }

    @Override
    public boolean isInMemory() {
        return this.wrapped.isInMemory();
    }

    @Override
    public long length() {
        return this.wrapped.length();
    }

    @Override
    public boolean renameTo(File file) {
        return this.wrapped.renameTo(file);
    }

    @Override
    public void setCharset(Charset charset) {
        this.wrapped.setCharset(charset);
    }

    @Override
    public void setContent(ByteBuf byteBuf) {
        try {
            this.checkSize(byteBuf.readableBytes());
        }
        catch (IOException iOException) {
            byteBuf.release();
            throw iOException;
        }
        if ((long)byteBuf.readableBytes() > this.limitSize && this.wrapped instanceof AbstractMemoryHttpData) {
            this.wrapped.release();
            this.wrapped = this.makeDiskData();
        }
        this.wrapped.setContent(byteBuf);
    }

    @Override
    public void setContent(File file) {
        this.checkSize(file.length());
        if (file.length() > this.limitSize && this.wrapped instanceof AbstractMemoryHttpData) {
            this.wrapped.release();
            this.wrapped = this.makeDiskData();
        }
        this.wrapped.setContent(file);
    }

    @Override
    public void setContent(InputStream inputStream) {
        if (this.wrapped instanceof AbstractMemoryHttpData) {
            this.wrapped.release();
            this.wrapped = this.makeDiskData();
        }
        this.wrapped.setContent(inputStream);
    }

    @Override
    public boolean isCompleted() {
        return this.wrapped.isCompleted();
    }

    @Override
    public InterfaceHttpData.HttpDataType getHttpDataType() {
        return this.wrapped.getHttpDataType();
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }

    public boolean equals(Object object) {
        return this.wrapped.equals(object);
    }

    @Override
    public int compareTo(InterfaceHttpData interfaceHttpData) {
        return this.wrapped.compareTo((InterfaceHttpData)interfaceHttpData);
    }

    public String toString() {
        return "Mixed: " + this.wrapped;
    }

    @Override
    public ByteBuf getChunk(int n) {
        return this.wrapped.getChunk(n);
    }

    @Override
    public File getFile() {
        return this.wrapped.getFile();
    }

    public D copy() {
        return (D)this.wrapped.copy();
    }

    public D duplicate() {
        return (D)this.wrapped.duplicate();
    }

    public D retainedDuplicate() {
        return (D)this.wrapped.retainedDuplicate();
    }

    public D replace(ByteBuf byteBuf) {
        return (D)this.wrapped.replace(byteBuf);
    }

    public D touch() {
        this.wrapped.touch();
        return (D)this;
    }

    public D touch(Object object) {
        this.wrapped.touch(object);
        return (D)this;
    }

    public D retain() {
        return (D)((HttpData)super.retain());
    }

    public D retain(int n) {
        return (D)((HttpData)super.retain(n));
    }
}

