/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.websocketx;

import java.util.concurrent.TimeUnit;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelInboundHandlerAdapter;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.handler.codec.http.FullHttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketClientHandshakeException;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler$ClientHandshakeStateEvent;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandshakeHandler$1;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandshakeHandler$2;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandshakeHandler$3;
import pro.gravit.repackage.io.netty.util.concurrent.ScheduledFuture;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

class WebSocketClientProtocolHandshakeHandler
extends ChannelInboundHandlerAdapter {
    private static final long DEFAULT_HANDSHAKE_TIMEOUT_MS = 10000L;
    private final WebSocketClientHandshaker handshaker;
    private final long handshakeTimeoutMillis;
    private ChannelHandlerContext ctx;
    private ChannelPromise handshakePromise;

    WebSocketClientProtocolHandshakeHandler(WebSocketClientHandshaker webSocketClientHandshaker) {
        this(webSocketClientHandshaker, 10000L);
    }

    WebSocketClientProtocolHandshakeHandler(WebSocketClientHandshaker webSocketClientHandshaker, long l) {
        this.handshaker = webSocketClientHandshaker;
        this.handshakeTimeoutMillis = ObjectUtil.checkPositive(l, "handshakeTimeoutMillis");
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
        this.handshakePromise = channelHandlerContext.newPromise();
    }

    @Override
    public void channelActive(ChannelHandlerContext channelHandlerContext) {
        super.channelActive(channelHandlerContext);
        this.handshaker.handshake(channelHandlerContext.channel()).addListener(new WebSocketClientProtocolHandshakeHandler$1(this, channelHandlerContext));
        this.applyHandshakeTimeout();
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        if (!this.handshakePromise.isDone()) {
            this.handshakePromise.tryFailure(new WebSocketClientHandshakeException("channel closed with handshake in progress"));
        }
        super.channelInactive(channelHandlerContext);
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        if (!(object instanceof FullHttpResponse)) {
            channelHandlerContext.fireChannelRead(object);
            return;
        }
        FullHttpResponse fullHttpResponse = (FullHttpResponse)object;
        try {
            if (!this.handshaker.isHandshakeComplete()) {
                this.handshaker.finishHandshake(channelHandlerContext.channel(), fullHttpResponse);
                this.handshakePromise.trySuccess();
                channelHandlerContext.fireUserEventTriggered((Object)WebSocketClientProtocolHandler$ClientHandshakeStateEvent.HANDSHAKE_COMPLETE);
                channelHandlerContext.pipeline().remove(this);
                return;
            }
            throw new IllegalStateException("WebSocketClientHandshaker should have been non finished yet");
        }
        finally {
            fullHttpResponse.release();
        }
    }

    private void applyHandshakeTimeout() {
        ChannelPromise channelPromise = this.handshakePromise;
        if (this.handshakeTimeoutMillis <= 0L || channelPromise.isDone()) {
            return;
        }
        ScheduledFuture<?> scheduledFuture = this.ctx.executor().schedule(new WebSocketClientProtocolHandshakeHandler$2(this, channelPromise), this.handshakeTimeoutMillis, TimeUnit.MILLISECONDS);
        channelPromise.addListener(new WebSocketClientProtocolHandshakeHandler$3(this, scheduledFuture));
    }

    ChannelFuture getHandshakeFuture() {
        return this.handshakePromise;
    }

    static /* synthetic */ ChannelPromise access$000(WebSocketClientProtocolHandshakeHandler webSocketClientProtocolHandshakeHandler) {
        return webSocketClientProtocolHandshakeHandler.handshakePromise;
    }

    static /* synthetic */ ChannelHandlerContext access$100(WebSocketClientProtocolHandshakeHandler webSocketClientProtocolHandshakeHandler) {
        return webSocketClientProtocolHandshakeHandler.ctx;
    }
}

