/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl;

import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLException;
import javax.security.auth.x500.X500Principal;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslEngineMap;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslKeyMaterialManager;
import pro.gravit.repackage.io.netty.handler.ssl.ReferenceCountedOpenSslClientContext;
import pro.gravit.repackage.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import pro.gravit.repackage.io.netty.internal.tcnative.CertificateCallback;

final class ReferenceCountedOpenSslClientContext$OpenSslClientCertificateCallback
implements CertificateCallback {
    private final OpenSslEngineMap engineMap;
    private final OpenSslKeyMaterialManager keyManagerHolder;

    ReferenceCountedOpenSslClientContext$OpenSslClientCertificateCallback(OpenSslEngineMap openSslEngineMap, OpenSslKeyMaterialManager openSslKeyMaterialManager) {
        this.engineMap = openSslEngineMap;
        this.keyManagerHolder = openSslKeyMaterialManager;
    }

    public void handle(long l, byte[] byArray, byte[][] byArray2) {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.engineMap.get(l);
        if (referenceCountedOpenSslEngine == null) {
            return;
        }
        try {
            X500Principal[] x500PrincipalArray;
            Set<String> set = ReferenceCountedOpenSslClientContext$OpenSslClientCertificateCallback.supportedClientKeyTypes(byArray);
            String[] stringArray = set.toArray(new String[0]);
            if (byArray2 == null) {
                x500PrincipalArray = null;
            } else {
                x500PrincipalArray = new X500Principal[byArray2.length];
                for (int i = 0; i < byArray2.length; ++i) {
                    x500PrincipalArray[i] = new X500Principal(byArray2[i]);
                }
            }
            this.keyManagerHolder.setKeyMaterialClientSide(referenceCountedOpenSslEngine, stringArray, x500PrincipalArray);
        }
        catch (Throwable throwable) {
            referenceCountedOpenSslEngine.initHandshakeException(throwable);
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw new SSLException(throwable);
        }
    }

    private static Set<String> supportedClientKeyTypes(byte[] byArray) {
        if (byArray == null) {
            return ReferenceCountedOpenSslClientContext.access$000();
        }
        HashSet<String> hashSet = new HashSet<String>(byArray.length);
        for (byte by : byArray) {
            String string = ReferenceCountedOpenSslClientContext$OpenSslClientCertificateCallback.clientKeyType(by);
            if (string == null) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    private static String clientKeyType(byte by) {
        switch (by) {
            case 1: {
                return "RSA";
            }
            case 3: {
                return "DH_RSA";
            }
            case 64: {
                return "EC";
            }
            case 65: {
                return "EC_RSA";
            }
            case 66: {
                return "EC_EC";
            }
        }
        return null;
    }
}

