/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util;

import java.util.LinkedHashMap;
import java.util.Map;
import pro.gravit.repackage.io.netty.util.DomainWildcardMappingBuilder$ImmutableDomainWildcardMapping;
import pro.gravit.repackage.io.netty.util.Mapping;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public class DomainWildcardMappingBuilder<V> {
    private final V defaultValue;
    private final Map<String, V> map;

    public DomainWildcardMappingBuilder(V v) {
        this(4, v);
    }

    public DomainWildcardMappingBuilder(int n, V v) {
        this.defaultValue = ObjectUtil.checkNotNull(v, "defaultValue");
        this.map = new LinkedHashMap<String, V>(n);
    }

    public DomainWildcardMappingBuilder<V> add(String string, V v) {
        this.map.put(this.normalizeHostName(string), ObjectUtil.checkNotNull(v, "output"));
        return this;
    }

    private String normalizeHostName(String string) {
        ObjectUtil.checkNotNull(string, "hostname");
        if (string.isEmpty() || string.charAt(0) == '.') {
            throw new IllegalArgumentException("Hostname '" + string + "' not valid");
        }
        if ((string = DomainWildcardMappingBuilder$ImmutableDomainWildcardMapping.normalize(ObjectUtil.checkNotNull(string, "hostname"))).charAt(0) == '*') {
            if (string.length() < 3 || string.charAt(1) != '.') {
                throw new IllegalArgumentException("Wildcard Hostname '" + string + "'not valid");
            }
            return string.substring(1);
        }
        return string;
    }

    public Mapping<String, V> build() {
        return new DomainWildcardMappingBuilder$ImmutableDomainWildcardMapping<V>(this.defaultValue, this.map);
    }
}

