/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util.collection;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import pro.gravit.repackage.io.netty.util.collection.IntObjectHashMap$1;
import pro.gravit.repackage.io.netty.util.collection.IntObjectHashMap$2;
import pro.gravit.repackage.io.netty.util.collection.IntObjectHashMap$EntrySet;
import pro.gravit.repackage.io.netty.util.collection.IntObjectHashMap$KeySet;
import pro.gravit.repackage.io.netty.util.collection.IntObjectMap;
import pro.gravit.repackage.io.netty.util.collection.IntObjectMap$PrimitiveEntry;
import pro.gravit.repackage.io.netty.util.internal.MathUtil;

public class IntObjectHashMap<V>
implements IntObjectMap<V> {
    public static final int DEFAULT_CAPACITY = 8;
    public static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final Object NULL_VALUE = new Object();
    private int maxSize;
    private final float loadFactor;
    private int[] keys;
    private V[] values;
    private int size;
    private int mask;
    private final Set<Integer> keySet = new IntObjectHashMap$KeySet(this);
    private final Set<Map.Entry<Integer, V>> entrySet = new IntObjectHashMap$EntrySet(this, null);
    private final Iterable<IntObjectMap$PrimitiveEntry<V>> entries = new IntObjectHashMap$1(this);

    public IntObjectHashMap() {
        this(8, 0.5f);
    }

    public IntObjectHashMap(int n) {
        this(n, 0.5f);
    }

    public IntObjectHashMap(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1");
        }
        this.loadFactor = f;
        int n2 = MathUtil.safeFindNextPositivePowerOfTwo(n);
        this.mask = n2 - 1;
        this.keys = new int[n2];
        Object[] objectArray = new Object[n2];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n2);
    }

    private static <T> T toExternal(T t) {
        assert (t != null) : "null is not a legitimate internal value. Concurrent Modification?";
        return t == NULL_VALUE ? null : (T)t;
    }

    private static <T> T toInternal(T t) {
        return (T)(t == null ? NULL_VALUE : t);
    }

    @Override
    public V get(int n) {
        int n2 = this.indexOf(n);
        return n2 == -1 ? null : (V)IntObjectHashMap.toExternal(this.values[n2]);
    }

    @Override
    public V put(int n, V v) {
        int n2;
        int n3 = n2 = this.hashIndex(n);
        do {
            if (this.values[n3] == null) {
                this.keys[n3] = n;
                this.values[n3] = IntObjectHashMap.toInternal(v);
                this.growSize();
                return null;
            }
            if (this.keys[n3] != n) continue;
            V v2 = this.values[n3];
            this.values[n3] = IntObjectHashMap.toInternal(v);
            return IntObjectHashMap.toExternal(v2);
        } while ((n3 = this.probeNext(n3)) != n2);
        throw new IllegalStateException("Unable to insert");
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends V> map) {
        if (map instanceof IntObjectHashMap) {
            IntObjectHashMap intObjectHashMap = (IntObjectHashMap)map;
            for (int i = 0; i < intObjectHashMap.values.length; ++i) {
                V v = intObjectHashMap.values[i];
                if (v == null) continue;
                this.put(intObjectHashMap.keys[i], v);
            }
            return;
        }
        for (Map.Entry<Integer, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(int n) {
        int n2 = this.indexOf(n);
        if (n2 == -1) {
            return null;
        }
        V v = this.values[n2];
        this.removeAt(n2);
        return IntObjectHashMap.toExternal(v);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, 0);
        Arrays.fill(this.values, null);
        this.size = 0;
    }

    @Override
    public boolean containsKey(int n) {
        return this.indexOf(n) >= 0;
    }

    @Override
    public boolean containsValue(Object object) {
        Object object2 = IntObjectHashMap.toInternal(object);
        for (V v : this.values) {
            if (v == null || !v.equals(object2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<IntObjectMap$PrimitiveEntry<V>> entries() {
        return this.entries;
    }

    @Override
    public Collection<V> values() {
        return new IntObjectHashMap$2(this);
    }

    @Override
    public int hashCode() {
        int n = this.size;
        for (int n2 : this.keys) {
            n ^= IntObjectHashMap.hashCode(n2);
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IntObjectMap)) {
            return false;
        }
        IntObjectMap intObjectMap = (IntObjectMap)object;
        if (this.size != intObjectMap.size()) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            V v = this.values[i];
            if (v == null) continue;
            int n = this.keys[i];
            Object v2 = intObjectMap.get(n);
            if (!(v == NULL_VALUE ? v2 != null : !v.equals(v2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.containsKey(this.objectToKey(object));
    }

    @Override
    public V get(Object object) {
        return this.get(this.objectToKey(object));
    }

    @Override
    public V put(Integer n, V v) {
        return this.put(this.objectToKey(n), v);
    }

    @Override
    public V remove(Object object) {
        return this.remove(this.objectToKey(object));
    }

    @Override
    public Set<Integer> keySet() {
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<Integer, V>> entrySet() {
        return this.entrySet;
    }

    private int objectToKey(Object object) {
        return (Integer)object;
    }

    private int indexOf(int n) {
        int n2;
        int n3 = n2 = this.hashIndex(n);
        do {
            if (this.values[n3] == null) {
                return -1;
            }
            if (n != this.keys[n3]) continue;
            return n3;
        } while ((n3 = this.probeNext(n3)) != n2);
        return -1;
    }

    private int hashIndex(int n) {
        return IntObjectHashMap.hashCode(n) & this.mask;
    }

    private static int hashCode(int n) {
        return n;
    }

    private int probeNext(int n) {
        return n + 1 & this.mask;
    }

    private void growSize() {
        ++this.size;
        if (this.size > this.maxSize) {
            if (this.keys.length == Integer.MAX_VALUE) {
                throw new IllegalStateException("Max capacity reached at size=" + this.size);
            }
            this.rehash(this.keys.length << 1);
        }
    }

    private boolean removeAt(int n) {
        --this.size;
        this.keys[n] = 0;
        this.values[n] = null;
        int n2 = n;
        int n3 = this.probeNext(n);
        V v = this.values[n3];
        while (v != null) {
            int n4 = this.keys[n3];
            int n5 = this.hashIndex(n4);
            if (n3 < n5 && (n5 <= n2 || n2 <= n3) || n5 <= n2 && n2 <= n3) {
                this.keys[n2] = n4;
                this.values[n2] = v;
                this.keys[n3] = 0;
                this.values[n3] = null;
                n2 = n3;
            }
            n3 = this.probeNext(n3);
            v = this.values[n3];
        }
        return n2 != n;
    }

    private int calcMaxSize(int n) {
        int n2 = n - 1;
        return Math.min(n2, (int)((float)n * this.loadFactor));
    }

    private void rehash(int n) {
        int[] nArray = this.keys;
        V[] VArray = this.values;
        this.keys = new int[n];
        Object[] objectArray = new Object[n];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n);
        this.mask = n - 1;
        block0: for (int i = 0; i < VArray.length; ++i) {
            V v = VArray[i];
            if (v == null) continue;
            int n2 = nArray[i];
            int n3 = this.hashIndex(n2);
            while (true) {
                if (this.values[n3] == null) {
                    this.keys[n3] = n2;
                    this.values[n3] = v;
                    continue block0;
                }
                n3 = this.probeNext(n3);
            }
        }
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(4 * this.size);
        stringBuilder.append('{');
        boolean bl = true;
        for (int i = 0; i < this.values.length; ++i) {
            V v = this.values[i];
            if (v == null) continue;
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.keyToString(this.keys[i])).append('=').append((Object)(v == this ? "(this Map)" : IntObjectHashMap.toExternal(v)));
            bl = false;
        }
        return stringBuilder.append('}').toString();
    }

    protected String keyToString(int n) {
        return Integer.toString(n);
    }

    static /* synthetic */ int access$300(IntObjectHashMap intObjectHashMap) {
        return intObjectHashMap.size;
    }

    static /* synthetic */ Set access$500(IntObjectHashMap intObjectHashMap) {
        return intObjectHashMap.entrySet;
    }

    static /* synthetic */ Object[] access$600(IntObjectHashMap intObjectHashMap) {
        return intObjectHashMap.values;
    }

    static /* synthetic */ boolean access$700(IntObjectHashMap intObjectHashMap, int n) {
        return intObjectHashMap.removeAt(n);
    }

    static /* synthetic */ int[] access$800(IntObjectHashMap intObjectHashMap) {
        return intObjectHashMap.keys;
    }

    static /* synthetic */ Object access$900(Object object) {
        return IntObjectHashMap.toExternal(object);
    }

    static /* synthetic */ Object access$1000(Object object) {
        return IntObjectHashMap.toInternal(object);
    }
}

